/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef lx_net_h
#define lx_net_h

#ifdef	__cplusplus
extern "C"
{
#if 0
}
#endif
#endif

#include "lx.h"

lx_map_t*lx_get_map (lx_t*lx, int iport);
int lx_receive (lx_t*lx, int*iport, char*p, unsigned length, int early);

int lx_send_xbar (lx_t*lx, int iport, lx_route_t*route, int timestamp, int*port, int*context);
int lx_send_scout (lx_t*lx, int iport, lx_route_t*route, unsigned timestamp, int reason, int*oiport, int*port, int*host_type, unsigned char mac_address [6], unsigned*map_version, unsigned char map_address [6], int*level, int*flags, int*context);
int lx_send_scout_reply (lx_t*lx, int iport, lx_scout_message_t*scout);
int lx_send_map_request (lx_t*lx, int iport, lx_route_t*route, unsigned timestamp, int type, int first);
int lx_send_map_reply (lx_t*lx, int iport, lx_map_t*m, lx_map_request_message_t*request);
int lx_send_xbar32 (lx_t*lx, int iport, lx_route_t*route, int timestamp, int*port, int*context, int*id, int*mask, int*absolute_port, int*quadrant_enabled);
int lx_wait_xbar32 (lx_t*lx, int iport, unsigned duration, int timestamp, int*port, int*context, int*id, int*mask, int*absolute_port, int*quadrant_enabled, int early);

int lx_wait_xbar (lx_t*lx, int iport, unsigned duration, int timestamp, int*port, int*context, int early);
int lx_wait_scout_reply (lx_t*lx, int iport, unsigned duration, int timestamp, int*oiport, int*port, int*host_type, unsigned char mac_address [6], unsigned*map_version, unsigned char map_address [6], int*level, int*flags, int*context, int early);
int lx_wait_map_reply (lx_t*lx, int iport, unsigned duration, int timestamp, int type, lx_map_reply_message_t*reply);

int lx_send_change_report (lx_t*lx, int iport, lx_change_t*change, unsigned char mac_address [6], lx_route_t*route, unsigned timestamp);
int lx_send_change_report_reply (lx_t*lx, int iport, lx_change_report_message_t*report);

void lx_set_alarm (lx_t*lx, unsigned duration);
void lx_clear_alarm (lx_t*lx);

void lx_map_receive_callback (lx_t*lx, int iport, lx_packet_t*p, int length);

void lx_xbar2net (lx_map_t*m, lx_xbar_t*from, lx_map_xbar_t*to);
void lx_net2xbar (lx_map_t*m, lx_map_xbar_t*from, lx_xbar_t*to, int num_hosts, int num_xbars);
void lx_host2net (lx_map_t*m, lx_host_t*from, lx_map_host_t*to);
void lx_net2host (lx_map_t*m, lx_map_host_t*from, lx_host_t*to, int num_hosts, int num_xbars);
void lx_net2xbar16 (lx_map_t*m, lx_map_xbar16_t*from, lx_xbar_t*to, int num_hosts, int num_xbars);
void lx_xbar162net (lx_map_t*m, lx_xbar_t*from, lx_map_xbar16_t*to);

int lx_set_routes (lx_map_t*m, int iport, int index);

#ifdef __cplusplus
#if 0
{
#endif
}
#endif

#endif /*lx_net_h*/
